param (
    [string]$PrinterName
)

try {
    # Druckername fuer Schwarz-Weiß und Farbe generieren
    $PrinterNameSW = "$PrinterName (SW)"
    $PrinterNameColor = "$PrinterName (Farbe)"
	
	# Aktuellen Skript-Ordner ermitteln
	#$ScriptPath = Split-Path -Parent $MyInvocation.MyCommand.Definition
	#$ConfigFile = "$ScriptPath\SwConfig.xml"

    Write-Host "Setze Standard-Druckeinstellungen fuer: $PrinterNameSW ..."
    
    # Setze den Druckmodus fuer Schwarz-Weiß auf Monochrome
	# Set-PrintConfiguration -PrinterName $PrinterNameSW -Color $false
	# Set-PrinterProperty -PrinterName $PrinterNameSW -PropertyName "PrintColorMode" -Value "Monochrome"
	# Set-PrintConfiguration -PrinterName $PrinterName -PrintTicketXML (Get-Content $ConfigFile -Raw)



    # Duplex fuer Schwarz-Weiß deaktivieren
    Set-PrintConfiguration -PrinterName $PrinterNameSW -DuplexingMode OneSided
    Set-PrintConfiguration -PrinterName $PrinterNameSW -Color Monochrome



    Write-Host "Setze Standard-Druckeinstellungen fuer: $PrinterNameColor ..."

    # Duplex fuer Farbe deaktivieren
    Set-PrintConfiguration -PrinterName $PrinterNameColor -DuplexingMode OneSided

    Write-Host "Fertig! Alle Einstellungen wurden erfolgreich gesetzt."
}
catch {
    Write-Host "Fehler: Konnte die Druckereinstellung nicht ändern. ueberpruefe, ob die Drucker '$PrinterNameSW' und '$PrinterNameColor' existieren!"
}
